<?php

header('Content-Type: application/json');

include 'db.php';



$user_id = $_GET['user_id'] ?? null;



if (!$user_id) {

    echo json_encode(["status" => "error", "message" => "User ID is required"]);

    exit;

}



// Escape user_id to prevent SQL injection

$user_id = mysqli_real_escape_string($conn, $user_id);



$response = [

    "status" => "error",

    "message" => "No orders found for this user"

];



// Query to get all orders for the user

$orders_query = "

  SELECT 

    o.order_no,

    o.Created_date,

    o.Order_id,
    o.Grand_total,
    o.Action_status,
    o.Payment_status
  FROM 

    orders o

  WHERE 

    o.Delete_status = 0 AND o.user_id = '$user_id'

  GROUP BY 

    o.Order_id

  ORDER BY 

    o.Created_date DESC;

";



$orders_result = mysqli_query($conn, $orders_query);



if ($orders_result && mysqli_num_rows($orders_result) > 0) {

    $orders = [];

    

    while ($order = mysqli_fetch_assoc($orders_result)) {

        $order_id = $order['Order_id'];

        

        // Get order items with product details

        $order_data_query = "

            SELECT 

                od.Product_id,

                od.qty,

                od.Product_total,

                p.Product_name,

                p.Product_image

            FROM 

                order_data od

            LEFT JOIN

                product p ON od.Product_id = p.Product_id

            WHERE 

                od.Order_id = '$order_id' AND od.Delete_status = 0

        ";

        $order_data_result = mysqli_query($conn, $order_data_query);

        

        $order_items = [];

        if ($order_data_result && mysqli_num_rows($order_data_result) > 0) {

            while ($item = mysqli_fetch_assoc($order_data_result)) {

                $order_items[] = [

                    'product_id' => $item['Product_id'],

                    'quantity' => $item['qty'],

                    'product_total' => $item['Product_total'],

                    'product_name' => $item['Product_name'],

                    'product_image' => $item['Product_image']

                ];

            }

        }

        

        $orders[] = [

            'order_no' => $order['order_no'],

            'order_id' => $order['Order_id'],

            'order_date' => $order['Created_date'],
            'action' => $order['Action_status'],
            'payment' =>$order['Payment_status'],
            'total' =>$order['Grand_total'],

            'products' => $order_items

        ];

    }

    

    $response = [

        "status" => "success",

        "message" => "Orders fetched successfully",

        "data" => $orders

    ];

}



echo json_encode($response);

?>